package cn.lyanzheng.myapplication;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.view.Gravity;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;

import static android.content.Context.MODE_PRIVATE;

public class VerifyDemo {
    final String APIURL = "https://yz.52tyun.com/api.php"; //请求接口
    final String APPID = "APPID"; //应用id
    final String APPKEY = "APPKEY"; //应用签名

    final String RC4_Key = "RC4密钥"; //RCE加密密钥
    String Markcode;
    Context context;

    public VerifyDemo(View v) {
        context = v.getContext();
        Markcode = Settings.System.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
        final EditText Edit = new EditText(context);
        AlertDialog.Builder dialog = new AlertDialog.Builder(context);
        dialog.setTitle("用户登录");
        dialog.setView(Edit);
        dialog.setPositiveButton("登录", null);
        dialog.setNegativeButton("解绑", null);
        dialog.setNeutralButton("退出", null);
        dialog.setCancelable(false);    //设置按钮是否可以按返回键取消,false则不可以取消
        final AlertDialog builder = dialog.create();
        builder.show();
        String oldKami= context.getSharedPreferences("Config",MODE_PRIVATE).getString("Kami","");
        Edit.setText(oldKami);
        builder.getButton(AlertDialog.BUTTON_POSITIVE).setOnClickListener(v1 -> {
            Login(Edit,builder);
        });
        builder.getButton(AlertDialog.BUTTON_NEGATIVE).setOnClickListener(v1 -> {
            Unmachine(Edit);
        });
        builder.getButton(AlertDialog.BUTTON_NEUTRAL).setOnClickListener(v1 -> {
            android.os.Process.killProcess(android.os.Process.myPid());
            System.exit(0);
        });
    }

    private void Login(EditText edit, AlertDialog dialog) {
        String Kami = String.valueOf(edit.getText());
        if (Kami.isEmpty()){
            Toast.makeText(context,"卡密不能为空！", Toast.LENGTH_SHORT).show();
            return;
        }
        final String time = String.valueOf(System.currentTimeMillis());
        String RandomMD5 = md5Java(time + APPKEY + Markcode);
        String MD5 = md5Java("kami=" + Kami + "&markcode=" + Markcode + "&t=" + time + "&" + APPKEY);
        String Str = RC4Util.encry_RC4_string("kami=" + Kami + "&markcode=" + Markcode + "&t=" + time + "&sign=" + MD5, RC4_Key);
      // Android 4.0 之后不能在主线程中请求HTTP请求
        new Thread(() -> {
            String body= HttpGet(APIURL ,"api=kmlogon&app=" + APPID + "&data=" + Str+"&markcode="+Markcode+"&t="+time+"&sign="+MD5+"&value="+RandomMD5);

            String Requset =RC4Util.decry_RC4( body,RC4_Key);
            try {
                JSONObject json=new JSONObject(Requset);
                int Code=json.getInt("code");
                if (Code!=200){
                    String Msg=json.getString("msg");
                    showToast(context,Msg);
                    return;
                }
                new Handler(Looper.getMainLooper()).post(dialog::dismiss);
               JSONObject vip= json.getJSONObject("msg");
                Long viptime= Long.valueOf(vip.getString("vip"));
                @SuppressLint("SimpleDateFormat")
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy 年 MM 月 dd 日 HH 时 mm 分 ss 秒");
                String sd2 = sdf2.format(new Date(viptime*1000));
                showToast(context,"登录成功！到期时间："+sd2);


            } catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }).start();


        SharedPreferences sharedPreferences=context.getSharedPreferences("Config",MODE_PRIVATE);
        SharedPreferences.Editor editor=sharedPreferences.edit();
        editor.putString("Kami",Kami);
        editor.apply();
    }


    private void Unmachine(EditText edit) {
        String Kami = String.valueOf(edit.getText());
        if (Kami.isEmpty()){
            Toast.makeText(context,"卡密不能为空！", Toast.LENGTH_SHORT).show();
            return;
        }
        final String time = String.valueOf(System.currentTimeMillis());
        String RandomMD5 = md5Java(time + APPKEY + Markcode);
        String MD5 = md5Java("kami=" + Kami + "&markcode=" + Markcode + "&t=" + time + "&" + APPKEY);
        String Str = RC4Util.encry_RC4_string("kami=" + Kami + "&markcode=" + Markcode + "&t=" + time + "&sign=" + MD5, RC4_Key);
        // Android 4.0 之后不能在主线程中请求HTTP请求
        new Thread(() -> {
            String body= HttpGet(APIURL ,"api=kmunmachine&app=" + APPID + "&data=" + Str+"&markcode="+Markcode+"&t="+time+"&sign="+MD5+"&value="+RandomMD5);
            String Requset =RC4Util.decry_RC4( body,RC4_Key);
            JSONObject json= null;
            try {
                json = new JSONObject(Requset);
                String Msg=json.getString("msg");
                showToast(context,Msg);
            } catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }).start();


    }

    public static String md5Java(String content) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(content.getBytes());
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("NoSuchAlgorithmException", e);
        }

        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 0x10) {
                hex.append(0);
            }
            hex.append(Integer.toHexString(b & 0xff));
        }

        return hex.toString();
    }


    public static void showToast(Context context, String text) {
      Toast toast = null;
        Looper myLooper = Looper.myLooper();
        if (myLooper == null) {
            Looper.prepare();
            myLooper = Looper.myLooper();
        }

        if (toast == null) {
            toast = Toast.makeText(context, text, Toast.LENGTH_LONG);
            toast.setGravity(Gravity.CENTER, 0, 0);
        }
        toast.show();
        if ( myLooper != null) {
            Looper.loop();
            myLooper.quit();
        }
    }
    public static String HttpGet(String url, String param) {
        StringBuilder result = new StringBuilder();
        BufferedReader in = null;
        try {
            String urlNameString = url + "?" + param;
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result.toString();
    }


}
